<?php 

include "admin/config/db.php";

?>
<html>
<head>
    <link rel="stylesheet" href="style.css">
    <link rel="preconnect" href="https://fonts.googleapis.com">
<link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
<link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;700;900&display=swap" rel="stylesheet">

<link rel="stylesheet" href="https://fonts.googleapis.com/css2?family=Material+Symbols+Outlined:opsz,wght,FILL,GRAD@24,400,0,0" />
</head>
<body>

<nav class="navbar">
  <div class="menu-toggle" id="mobile-menu">
  <span class="material-symbols-outlined" style="font-size: 60px;">menu</span>
</div>

  <div class="logo-container" style="max-width: 180px;">
    <img src = "http://grovia.pro/admin/assets/img/logo.png" style="max-width: inherit;">
  </div>
</nav>

<section class="slider-section">
  <div class="slider-container">
    <?php
    // Fetch active banners from the 'banners' table
    $banner_sql = "SELECT banner_image, target_url FROM banners WHERE status = 'Active' ORDER BY created_at DESC";
    $banner_result = mysqli_query($conn, $banner_sql);

    if (mysqli_num_rows($banner_result) > 0) {
        while($banner = mysqli_fetch_assoc($banner_result)) {
            ?>
    <div class="slider-card">
      <a href="<?php echo htmlspecialchars($banner['target_url']); ?>">
                <img src="admin/<?php echo htmlspecialchars($banner['banner_image']); ?>" alt="Promotion">
      </a>
    </div>
    <?php
        }
    } else {
        // Fallback if no banners are active in DB
        echo '<div class="slider-card"><img src="banner1.jpg" alt="Default Banner"></div>';
    }
    ?>
  </div>
</section>

<section class="stories-section">
  <div class="stories-header">
    <span class="live-indicator"></span>
    <h2>Stories</h2>
  </div>
  <div class="stories-container">
    <?php
    // Fetching from your 'stories' table (image_df3a30.png)
    $story_sql = "SELECT story_title, thumbnail_image FROM stories WHERE status = 'Active' ORDER BY created_at DESC";
    $story_res = mysqli_query($conn, $story_sql);

    if (mysqli_num_rows($story_res) > 0) {
        while($story = mysqli_fetch_assoc($story_res)) { ?>
              <div class="story-item">
                <div class="profile-wrapper">
                  <div class="profile-circle">
                    <img src="admin/<?php echo htmlspecialchars($story['thumbnail_image']); ?>" alt="Vikas Khanna">
                    <span class="category-tag">CATEGORY - 1</span>
                  </div>
                <div class="birthday-badge"><div class="marquee-box">
                    <span class="marquee-text"><?php echo htmlspecialchars($story['story_title']); ?></span>
                </div>
                </div>
              </div>
                <p class="profile-name">Admin</p>
            </div>
    <?php } 
    } else {
        echo "<p style='color:gray; padding-left:20px;'>No active stories.</p>";
    } ?>
 </div>

    
  <div class="dotted-separator"></div>

  <section class="special-events">
  <div class="stories-header">
    <span class="live-indicator"></span>
    <h2>Special Events</h2>
  </div>

  <div class="stories-container">
    <div class="story-item">
      <div class="profile-wrapper">
        <div class="profile-circle">
          <img src="speaker-image.jpg" alt="Sahil Srivastava">
          <span class="category-tag">CATEGORY - 1</span>
        </div>
        <div class="birthday-badge">
            <div class="marquee-box">
                <span class="marquee-text">Happy Birthday to the Legend!</span>
            </div>
        </div>
    </div>
      <p class="profile-name">By Sahil Srivastava</p>
    </div>

    </div>
  
  <div class="dotted-separator"></div>
</section>

<section class="welcome-section">
  <div class="stories-container welcome-scroll-wrapper">
    <div class="welcome-card">
      <div class="welcome-content">
        WELCOME
      </div>
    </div>

    <div class="welcome-card">
      <div class="welcome-content">
        WELCOME
      </div>
    </div>

    <div class="welcome-card">
      <div class="welcome-content">
        WELCOME
      </div>
    </div>
    
    </div>
  
  <div class="dotted-separator"></div>
</section>

<?php
// SQL: Fetch only active categories that have at least one template
$cat_query = "SELECT DISTINCT c.category_name 
              FROM categories c 
              INNER JOIN templates t ON c.category_name = t.category_name 
              WHERE c.status = 'Active'";
$cat_result = mysqli_query($conn, $cat_query);

if ($cat_result && mysqli_num_rows($cat_result) > 0) {
    while ($cat_row = mysqli_fetch_assoc($cat_result)) {
        $category_name = $cat_row['category_name'];
?>
    <div class="quotes-section">
      <div class="quotes-container-box">
        <div class="quotes-header">
          <div class="header-left">
            <span class="live-indicator"></span>
            <h2><?php echo htmlspecialchars(strtoupper($category_name)); ?> <span class="material-symbols-outlined" style="color: #ffcc00; vertical-align: middle;">bolt</span></h2>
          </div>
          <div class="header-right">
            <span class="material-symbols-outlined" style="font-size: 40px; color: #ffcc00;">arrow_circle_right</span>
          </div>
        </div>

        <div class="banners-scroll-wrapper">
          <?php
          // Fetch templates for this specific category
          $safe_cat = mysqli_real_escape_string($conn, $category_name);
          $temp_query = "SELECT thumbnail_image, template_id FROM templates WHERE category_name = '$safe_cat'";
          $temp_result = mysqli_query($conn, $temp_query);

          while ($temp_row = mysqli_fetch_assoc($temp_result)) {
          ?>
            <div class="banner-item">
              <div class="banner-square">
                  <img src="admin/<?php echo htmlspecialchars($temp_row['thumbnail_image']); ?>" 
                       alt="Template <?php echo $temp_row['template_id']; ?>"
                       style="height: 100%; width: 100%; object-fit: cover; border-radius: inherit;">
              </div>
              <p>Banner <?php echo $temp_row['template_id']; ?></p>
            </div>
          <?php } ?>
        </div>
      </div>
      <div class="dotted-separator"></div>
    </div>
<?php 
    }
} else {
    echo "<p style='color:white; text-align:center;'>No categories available.</p>";
}
?>


</section>


<!-- Menu Design -->
<div class="sidebar-overlay" id="overlay"></div>

<aside class="sidebar" id="sidebar">
  <div class="sidebar-header">
    <div class="profile-icon-large">
      <img src="https://cdn.pixabay.com/photo/2020/07/01/12/58/icon-5359553_1280.png" style="max-width: 150px;">
    </div>
    <h3 class="user-name">Lovekesh Choudhary</h3>
    <p class="user-info">Reg No. | 8279464694</p>
    <p class="user-info">Code: GV1098</p>
  </div>

  <ul class="sidebar-menu">
    <li><span class="material-symbols-outlined">person</span> <p>Profile</p></li>
    <li><span class="material-symbols-outlined">settings</span>  <p>Banner Settings</p></li>
    <li><span class="material-symbols-outlined">account_balance_wallet</span>  <p>My Wallet</p></li>
    <li><span class="material-symbols-outlined">school</span>  <p>Learn how to use Grovia</p></li>
    <li><span class="material-symbols-outlined">featured_seasonal_and_gifts</span> <p>Refer & Earn</p> </li>
    <li><span class="material-symbols-outlined">auto_delete</span> <p>Clear Cache</p> </li>
    <li>
        <span class="material-symbols-outlined">chat</span> 
        <div><p style="margin-bottom: 0;">Contact</p><small style="font-size: 20px;">Call or whatsapp</small></div>
    </li>
    <li><span class="material-symbols-outlined">directions_run</span> <p>Follow Us</p></li>
    <li><span class="material-symbols-outlined">star</span> <p>Rate Us</p></li>
  </ul>

  <div class="sidebar-footer">
    <p>Made with ❤️ in India</p>
    <button class="logout-btn">
      <span class="material-symbols-outlined">logout</span> Logout
    </button>
  </div>
</aside>



<script src="custom.js"></script>
</body>
</html>

