<!DOCTYPE html>
<html lang="en">
<head>
<style>
    :root {
        --sidebar-bg: #3b4368;        /* Deep Navy-Purple from image */
        --sidebar-hover: #4a537d;
        --topbar-bg: #ffffff;
        --text-color: #ffffff;
        --border-color: rgba(255, 255, 255, 0.1);
        --accent-color: #3498db;
    }

    body { margin: 0; font-family: 'Segoe UI', sans-serif; background: #f4f7f6; display: flex; }

    /* --- SIDEBAR & LOGO --- */
    .sidebar-container {
        width: 280px;
        background-color: var(--sidebar-bg);
        height: 100vh;
        position: fixed;
        left: 0;
        top: 0;
        display: flex;
        flex-direction: column;
    }

    .logo-area {
        padding: 30px 25px;
        text-align: center;
        border-bottom: 1px solid var(--border-color);
    }

    .logo-area img {
        max-width: 150px; /* Adjust based on your logo size */
        height: auto;
    }

    .sidebar-menu { list-style: none; padding: 0; margin: 0; overflow-y: auto; flex-grow: 1; }
    .menu-item { border-bottom: 1px solid var(--border-color); }
    .menu-link {
        display: flex; justify-content: space-between; align-items: center;
        padding: 18px 25px; text-decoration: none; color: var(--text-color);
        font-size: 16px; transition: 0.3s;
    }
    .menu-link:hover { background: var(--sidebar-hover); }

    /* --- TOP BAR --- */
    .header-top {
        position: fixed;
        top: 0;
        left: 280px;
        right: 0;
        height: 70px;
        background: var(--topbar-bg);
        display: flex;
        justify-content: flex-end;
        align-items: center;
        padding: 0 30px;
        box-shadow: 0 2px 10px rgba(0,0,0,0.05);
        z-index: 100;
    }

    .top-actions { display: flex; align-items: center; gap: 25px; }

    .icon-btn { 
        background: none; border: none; cursor: pointer; position: relative; font-size: 20px; color: #666; 
    }

    .badge {
        position: absolute; top: -5px; right: -5px; background: #e74c3c;
        color: white; font-size: 10px; padding: 2px 5px; border-radius: 10px;
    }

    .user-profile { display: flex; align-items: center; gap: 12px; cursor: pointer; }
    .user-profile img { width: 40px; height: 40px; border-radius: 50%; object-fit: cover; border: 2px solid #eee; }
    .user-name { font-weight: 600; font-size: 14px; color: #333; }

    /* Chevron arrow */
    .chevron { width: 8px; height: 8px; border-top: 2px solid #fff; border-right: 2px solid #fff; transform: rotate(45deg); opacity: 0.6; }

    /* Content Area Spacer */
    .main-content { margin-left: 280px; margin-top: 70px; padding: 30px; width: 100%; }
</style>
</head>
<body>

<div class="sidebar-container">
    <div class="logo-area">
        <img src="assets/img/logo.png" alt="GROVIA LOGO">
    </div>
    <ul class="sidebar-menu">
        <li class="menu-item"><a href="dashboard.php" class="menu-link"><span>Back to Manage All</span><div class="chevron"></div></a></li>
    </ul>
</div>

<?php include_once 'top-bar.php';?>

</body>
</html>