<?php 
session_start();
require_once 'config/db.php';

// Fetch approvals with User Names for better context
$query = "SELECT pa.*, u.name, u.mobile 
          FROM pending_approvals pa
          JOIN users u ON pa.user_id = u.id 
          WHERE pa.status = 'Awaiting'
          ORDER BY pa.uploaded_at DESC";

$result = $conn->query($query);
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Pending Approvals | Grovia Admin</title>
    <style>
        :root { --sidebar-bg: #3b4368; --accent: #3498db; --bg: #f4f7f6; }
        body { margin: 0; font-family: 'Segoe UI', sans-serif; background: var(--bg); display: flex; }
        .sidebar { width: 280px; background: var(--sidebar-bg); height: 100vh; position: fixed; color: #fff; }
        .main-content { margin-left: 280px; width: 100%; padding: 40px; }
        
        .approval-card { background: #fff; border-radius: 12px; box-shadow: 0 4px 20px rgba(0,0,0,0.05); overflow: hidden; }
        .approval-table { width: 100%; border-collapse: collapse; }
        .approval-table th { background: #f8f9fa; padding: 15px; text-align: left; color: #636e72; font-size: 11px; text-transform: uppercase; letter-spacing: 1px; }
        .approval-table td { padding: 15px; border-top: 1px solid #eee; font-size: 14px; vertical-align: middle; }

        .preview-thumb { width: 60px; height: 60px; object-fit: cover; border-radius: 8px; border: 1px solid #ddd; cursor: zoom-in; }
        
        .info-badge { padding: 5px 12px; border-radius: 20px; font-size: 10px; font-weight: bold; text-transform: uppercase; }
        .pay-success { background: #e8f5e9; color: #2e7d32; }
        .pay-pending { background: #fff3e0; color: #ef6c00; }
        
        .btn-approve { background: #2ecc71; color: white; border: none; padding: 8px 15px; border-radius: 5px; cursor: pointer; font-weight: 600; text-decoration:none; }
        .btn-reject { background: #e74c3c; color: white; border: none; padding: 8px 15px; border-radius: 5px; cursor: pointer; font-weight: 600; margin-left: 5px; }
    </style>
</head>
<body>
<?php include ('side-bar.php')?>

<div class="main-content">
    <div style="display: flex; justify-content: space-between; align-items: center; margin-bottom: 30px;">
        <h2 style="margin:0;">Pending Approvals</h2>
        <div style="color:#888;">Awaiting Action: <strong><?php echo $result->num_rows; ?></strong></div>
    </div>

    <div class="approval-card">
        <table class="approval-table">
            <thead>
                <tr>
                    <th>ID</th>
                    <th>User</th>
                    <th>Type</th>
                    <th>File Preview</th>
                    <th>Payment Status</th>
                    <th>Amount</th>
                    <th>Actions</th>
                </tr>
            </thead>
            <tbody>
                <?php while($row = $result->fetch_assoc()): ?>
                <tr>
                    <td style="font-weight:bold; color:var(--accent);"><?php echo $row['approval_id']; ?></td>
                    <td>
                        <div style="font-size:11px;"><?php echo htmlspecialchars($row['name']); ?></div>
                        <div style="font-weight:600; color:#999;"><?php echo $row['mobile']; ?></div>
                    </td>
                    <td>
                        <div style="font-weight:bold; color:#34495e;"><?php echo str_replace('_', ' ', $row['upload_type']); ?></div>
                        <div style="font-size:10px; color:#aaa;"><?php echo date('d M, H:i', strtotime($row['uploaded_at'])); ?></div>
                    </td>
                    <td>
                        <a href="../<?php echo $row['uploaded_file']; ?>" target="_blank">
                            <img src="../<?php echo $row['uploaded_file']; ?>" class="preview-thumb" onerror="this.src='https://img.freepik.com/premium-vector/pending-rubber-stamp-design-art-illustration_969463-2336.jpg'">
                        </a>
                    </td>
                    <td>
                        <span class="info-badge <?php echo ($row['payment_status'] == 'Successful') ? 'pay-success' : 'pay-pending'; ?>">
                            <?php echo $row['payment_status']; ?>
                        </span>
                    </td>
                    <td style="font-weight:bold;">₹<?php echo number_format($row['amount'], 2); ?></td>
                    <td>
                        <button onclick="processRequest(<?php echo $row['id']; ?>, 'approve', this)" class="btn-approve">Approve</button>
                        <button onclick="processRequest(<?php echo $row['id']; ?>, 'reject', this)" class="btn-reject">Reject</button>
                    </td>
                </tr>
                <?php endwhile; ?>
                <?php if($result->num_rows == 0): ?>
                    <tr><td colspan="7" style="text-align:center; padding:50px; color:#999;">Everything is clear! No pending approvals.</td></tr>
                <?php endif; ?>
            </tbody>
        </table>
    </div>
</div>

<script>

async function processRequest(id, action, element) {
    const confirmMsg = (action === 'approve') 
        ? "Are you sure you want to APPROVE this?" 
        : "Are you sure you want to REJECT this submission?";

    if (!confirm(confirmMsg)) return;

    const row = element.closest('tr');
    row.style.opacity = '0.5';

    try {
        const response = await fetch(`api/process-approval.php?id=${id}&action=${action}`);
        const data = await response.json();

        if (data.success) {
            // Animate row removal from queue
            row.style.transition = 'all 0.4s ease';
            row.style.transform = (action === 'approve') ? 'translateX(-20px)' : 'translateX(20px)';
            row.style.opacity = '0';
            
            setTimeout(() => {
                row.remove();
                // If notification system from top-bar exists, update it
                if(typeof showToast === 'function') showToast(data.message);
            }, 400);
        } else {
            row.style.opacity = '1';
            alert(data.message);
        }
    } catch (error) {
        row.style.opacity = '1';
        alert("Network error. Please try again.");
    }
}
</script>

</body>
</html>