<?php 
session_start();
require_once 'config/auth_check.php';
require_once 'config/db.php';

// Check if search query exists
$search = isset($_GET['search']) ? $conn->real_escape_string($_GET['search']) : '';

// Update SQL Query to include search logic
if ($search != '') {
    $query = "SELECT * FROM upliners 
              WHERE upliner_name LIKE '%$search%' 
              OR upliner_code LIKE '%$search%' 
              ORDER BY id DESC";
} else {
    $query = "SELECT * FROM upliners ORDER BY id DESC";
}

$result = $conn->query($query);
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <title>Admin - Manage Upliners</title>
  <link rel="stylesheet" href="assets/css/admin.css">
  <style>
    /* Search Bar Styling */
    .search-container {
      background: #fff;
      padding: 15px;
      border-radius: 10px;
      box-shadow: 0 2px 10px rgba(0,0,0,0.05);
      margin-bottom: 25px;
      display: flex;
      gap: 10px;
    }
    .search-input {
      flex: 1;
      padding: 10px 15px;
      border: 1px solid #ddd;
      border-radius: 5px;
      font-size: 14px;
    }
    .btn-search {
      background: #3498db;
      color: white;
      border: none;
      padding: 10px 20px;
      border-radius: 5px;
      cursor: pointer;
    }
    .btn-clear {
      background: #ecf0f1;
      color: #7f8c8d;
      text-decoration: none;
      padding: 10px 15px;
      border-radius: 5px;
      font-size: 14px;
    }
    button{
        width: 20%;
    }

    /* Grid and Card Styling (previous styles maintained) */
    .upliner-grid { display: grid; grid-template-columns: repeat(auto-fill, minmax(300px, 1fr)); gap: 20px; }
    .upliner-card { background: #fff; border-radius: 12px; padding: 20px; box-shadow: 0 4px 15px rgba(0,0,0,0.05); border-top: 4px solid #3498db; }
    .u-code { background: #e1f5fe; color: #0288d1; font-weight: bold; padding: 4px 8px; border-radius: 4px; font-size: 12px; }
    .status-badge { font-size: 11px; text-transform: uppercase; padding: 3px 8px; border-radius: 20px; font-weight: 600; }
    .status-active { background: #d4edda; color: #155724; }
    .status-pending { background: #fff3cd; color: #856404; }
    .status-inactive { background: #f8d7da; color: #721c24; }
    .u-photo { width: 60px; height: 60px; border-radius: 8px; object-fit: cover; margin-right: 5px; border: 1px solid #eee; }

    .alert { padding: 15px; margin-bottom: 20px; border-radius: 4px; text-align: center; }
    .success { background-color: #12812eff; color: #ffffffff; }
    .error { background-color: #ff0017; color: #ffffffff; }
    label { display: block; margin-bottom: 8px; font-weight: 600; color: #4a5568; }
  </style>
</head>
<body>

<?php include 'side-bar.php' ?>

<div class="main">
  <div style="display: flex; justify-content: space-between; align-items: center; margin-bottom: 20px;">
    <h2>Upliner Directory</h2>
    <a href="add-upliners.php" class="btn-view" style="text-decoration:none; background:#2ecc71; color:#fff; padding:8px 15px; border-radius:5px;">+ Add New</a>
  </div>
        <?php if (isset($_SESSION['msg'])): ?>
    <div class="alert <?php echo $_SESSION['msg_type']; ?>">
      <?php echo $_SESSION['msg']; unset($_SESSION['msg']); unset($_SESSION['msg_type']); ?>
    </div>
  <?php endif; ?>

  <form action="" method="GET" class="search-container">
    <input type="text" name="search" class="search-input" 
           placeholder="Search by Name or Upliner Code (e.g. GVU0001)..." 
           value="<?php echo htmlspecialchars($search); ?>">
    <button type="submit" class="btn-search">Search</button>
    <?php if($search != ''): ?>
      <a href="manage-upliner.php" class="btn-clear">Clear Results</a>
    <?php endif; ?>
  </form>

  <div class="upliner-grid">
    <?php if ($result->num_rows > 0): ?>
      <?php while($row = $result->fetch_assoc()): ?>
        <div class="upliner-card">
          <div style="display: flex; justify-content: space-between; align-items: start;">
            <div>
              <strong style="font-size: 18px;"><?php echo $row['upliner_name']; ?></strong><br>
              <span class="u-code"><?php echo $row['upliner_code']; ?></span>
            </div>
            <span class="status-badge status-<?php echo $row['status']; ?>">
                <?php echo $row['status']; ?>
            </span>
          </div>

          <div style="margin: 15px 0;">
            <?php for($i=1; $i<=3; $i++): ?>
              <?php if(!empty($row['photo_'.$i])): ?>
                <img src="<?php echo $row['photo_'.$i]; ?>" class="u-photo">
              <?php endif; ?>
            <?php endfor; ?>
          </div>

          <div style="border-top: 1px solid #eee; padding-top: 15px; display: flex; justify-content: space-between;">
            <a href="edit-upliner.php?id=<?php echo $row['id']; ?>" style="color: #3498db; text-decoration: none; font-size: 14px;">Edit Profile</a>
            <a href="delete-upliner.php?id=<?php echo $row['id']; ?>" 
               style="color: #e74c3c; text-decoration: none; font-size: 14px;"
               onclick="return confirm('Delete this upliner?');">Delete</a>
          </div>
        </div>
      <?php endwhile; ?>
    <?php else: ?>
      <div style="text-align: center; width: 100%; padding: 50px;">
        <p style="color: #7f8c8d;">No upliners found matching "<strong><?php echo htmlspecialchars($search); ?></strong>"</p>
      </div>
    <?php endif; ?>
  </div>
</div>

</body>
</html>