<?php 
session_start();
require_once 'config/auth_check.php';
require_once 'config/db.php';

// SQL Query using Joins to fetch Category and Sub-Category names
$query = "SELECT s.*, 
          c.category_name AS cat_name, 
          sc.sub_category_name AS sub_name
          FROM stories s
          LEFT JOIN categories c ON s.target_id = c.id AND s.target_type = 'category'
          LEFT JOIN sub_categories sc ON s.target_id = sc.id AND s.target_type = 'sub_category'
          ORDER BY s.id DESC";
$result = $conn->query($query);
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Manage Stories | Grovia Admin</title>
    <style>
        :root { --sidebar-bg: #3b4368; --accent: #3498db; --bg-body: #f4f7f6; }
        body { margin: 0; font-family: 'Segoe UI', sans-serif; background: var(--bg-body); display: flex; }

        /* Sidebar & Layout */
        .sidebar { width: 280px; background: var(--sidebar-bg); height: 100vh; position: fixed; color: #fff; }
        .main-content { margin-left: 280px; width: 100%; }
        .container { padding: 30px; }

        /* Table Styling */
        .story-card { background: #fff; border-radius: 12px; box-shadow: 0 4px 20px rgba(0,0,0,0.08); overflow: hidden; }
        .story-table { width: 100%; border-collapse: collapse; }
        .story-table th { background: #f8f9fa; padding: 15px; text-align: left; color: #636e72; font-size: 11px; text-transform: uppercase; letter-spacing: 1px; }
        .story-table td { padding: 15px; border-top: 1px solid #eee; font-size: 14px; vertical-align: middle; }
        
        /* Thumbnail */
        .thumb-preview { width: 75px; height: 75px; object-fit: cover; border-radius: 6px; border: 1px solid #ddd; background: #eee; }

        /* Target Labels */
        .target-label { font-size: 10px; color: #aaa; text-transform: uppercase; display: block; margin-top: 2px; }
        
        /* Status Badges */
        .badge { padding: 5px 12px; border-radius: 20px; font-size: 11px; font-weight: bold; }
        .status-active { background: #e8f5e9; color: #2e7d32; }
        .status-inactive { background: #ffebee; color: #c62828; }
        
        /* Date Styling */
        .date-box { color: #2d3436; font-weight: 500; }
        .date-label { color: #95a5a6; font-size: 11px; margin-bottom: 3px; }

        .btn-add { background: #2ecc71; color: #fff; padding: 10px 20px; border-radius: 6px; text-decoration: none; font-weight: bold; }
    </style>
</head>
<body>

<?php include 'side-bar.php' ?>

<div class="main-content">
    <div class="container">
        <div style="display: flex; justify-content: space-between; align-items: center; margin-bottom: 30px;">
            <div>
                <h2 style="margin:0;">Stories Content Feed</h2>
                <p style="color:#888; margin-top:5px;">Manage vertical visibility for specific network nodes.</p>
            </div>
            <a href="add-story.php" class="btn-add">+ Add New Story</a>
        </div>

        <div class="story-card">
            <table class="story-table">
                <thead>
                    <tr>
                        <th>Thumbnails</th>
                        <th>Story Details</th>
                        <th>Target Destination</th>
                        <th>Start Date</th>
                        <th>End Date</th>
                        <th>Status</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    <?php while($row = $result->fetch_assoc()): ?>
                    <tr>
                        <td>
                            <img src="<?php echo $row['thumbnail_image']; ?>" class="thumb-preview" onerror="this.src='assets/img/placeholder.png'">
                        </td>
                        <td>
                            <div style="font-weight:bold; color:#2d3436;"><?php echo htmlspecialchars($row['story_title']); ?></div>
                            <div style="font-size:11px; color:#999;"><?php echo $row['story_id']; ?></div>
                        </td>
                        <td>
                            <div style="font-weight:600; color:var(--accent);">
                                <?php 
                                    // Logic to show Name instead of Code
                                    echo ($row['target_type'] == 'category') ? $row['cat_name'] : $row['sub_name']; 
                                ?>
                            </div>
                            <span class="target-label">
                                <?php echo ($row['target_type'] == 'category') ? 'Primary Category' : 'Sub-Category Unit'; ?>
                            </span>
                        </td>
                        <td>
                            <div class="date-label">Visible From</div>
                            <div class="date-box"><?php echo date('d M, Y', strtotime($row['start_date'])); ?></div>
                        </td>
                        <td>
                            <div class="date-label">Expiring On</div>
                            <div class="date-box"><?php echo date('d M, Y', strtotime($row['end_date'])); ?></div>
                        </td>
                        <td>
                            <span class="badge <?php echo ($row['status'] == 'Active') ? 'status-active' : 'status-inactive'; ?>">
                                <?php echo $row['status']; ?>
                            </span>
                        </td>
                        <td>
                            <a href="edit-story.php?id=<?php echo $row['id']; ?>" style="color:var(--accent); text-decoration:none; font-weight:600;">Edit</a> |
                            <a href="javascript:void(0)" onclick="deleteStory(<?php echo $row['id']; ?>, this)" style="color:#e74c3c; text-decoration:none; font-weight:600;">Delete</a>
                        </td>
                    </tr>
                    <?php endwhile; ?>
                </tbody>
            </table>
        </div>
    </div>
</div>

<script>
async function deleteStory(id, el) {
    if(!confirm("Are you sure? This will remove the story asset from the network.")) return;
    const res = await fetch(`api/delete-story.php?id=${id}`);
    const data = await res.json();
    if(data.success) {
        el.closest('tr').style.opacity = '0';
        setTimeout(() => el.closest('tr').remove(), 500);
    } else {
        alert(data.message);
    }
}
</script>

</body>
</html>