<?php 
session_start();
require_once 'config/auth_check.php';
require_once 'config/db.php';

// Search logic
$search = isset($_GET['search']) ? $conn->real_escape_string($_GET['search']) : '';
$where_clause = "";
if ($search != '') {
    $where_clause = "WHERE category_name LIKE '%$search%' OR category_id LIKE '%$search%'";
}

// Fetch categories and count their sub-categories using a Left Join
$query = "SELECT c.*, COUNT(s.id) as sub_count 
          FROM categories c
          LEFT JOIN sub_categories s ON c.id = s.cat_id
          $where_clause
          GROUP BY c.id
          ORDER BY c.id DESC";
$result = $conn->query($query);
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <title>Admin - Manage Categories</title>
  <link rel="stylesheet" href="assets/css/admin.css">
  <style>
    .cat-table {
        width: 100%;
        border-collapse: collapse;
        background: #fff;
        border-radius: 8px;
        box-shadow: 0 4px 10px rgba(0,0,0,0.05);
    }
    .cat-table th, .cat-table td {
        padding: 15px;
        text-align: left;
        border-bottom: 1px solid #eee;
    }
    .cat-table th { background: #f8f9fa; font-weight: 600; }
    
    .count-badge {
        background: #3498db;
        color: white;
        padding: 2px 8px;
        border-radius: 10px;
        font-size: 12px;
        font-weight: bold;
    }
    .badge-all { background: #e8f5e9; color: #2e7d32; padding: 4px 8px; border-radius: 4px; font-size: 11px; font-weight: 600; }
    .badge-selective { background: #fff3e0; color: #ef6c00; padding: 4px 8px; border-radius: 4px; font-size: 11px; font-weight: 600; }
    
    .status-active { color: #2ecc71; font-weight: bold; }
    .status-inactive { color: #e74c3c; font-weight: bold; }
  </style>
</head>
<body>

<?php include 'side-bar.php' ?>

<div class="main">
  <div style="display: flex; justify-content: space-between; align-items: center; margin-bottom: 20px;">
    <h2>Main Categories</h2>
    <a href="add-categories.php" class="btn-view" style="text-decoration:none; background:#3498db; color:#fff; padding:8px 15px; border-radius:5px;">+ Create New</a>
  </div>

  <form action="" method="GET" style="margin-bottom: 20px; display: flex; gap: 10px;">
    <input type="text" name="search" placeholder="Search by name or CAT ID..." value="<?php echo htmlspecialchars($search); ?>" style="flex: 1; padding: 10px; border: 1px solid #ddd; border-radius: 5px;">
    <button type="submit" style="background:#3498db; color:white; border:none; padding:10px 20px; border-radius:5px; cursor:pointer; width:50%;">Search</button>
  </form>

  <table class="cat-table">
    <thead>
      <tr>
        <th>Code</th>
        <th>Category Name</th>
        <th>Sub-Categories</th>
        <th>Visibility</th>
        <th>Status</th>
        <th>Action</th>
      </tr>
    </thead>
    <tbody>
      <?php if ($result->num_rows > 0): ?>
        <?php while($row = $result->fetch_assoc()): ?>
          <tr>
            <td><code style="color:#e67e22; font-weight:bold;"><?php echo $row['category_id']; ?></code></td>
            <td><strong><?php echo $row['category_name']; ?></strong></td>
            <td>
                <span class="count-badge"><?php echo $row['sub_count']; ?></span> 
                <a href="manage-sub-categories.php?search=<?php echo urlencode($row['category_name']); ?>" style="font-size: 12px; margin-left: 5px; color:#3498db;">View</a>
            </td>
            <td>
              <span class="<?php echo $row['companies_allowed'] == 'For All' ? 'badge-all' : 'badge-selective'; ?>">
                <?php echo $row['companies_allowed']; ?>
              </span>
            </td>
            <td class="status-<?php echo ($row['status'] == 'Active') ? 'active' : 'inactive'; ?>">
                <?php echo $row['status']; ?>
            </td>
            <td>
              <a href="edit-category.php?id=<?php echo $row['id']; ?>" style="color:#3498db; text-decoration:none;">Edit</a> |
              <a href="delete-category.php?id=<?php echo $row['id']; ?>" style="color:#e74c3c; text-decoration:none;" onclick="return confirm('Deleting this category will delete all its sub-categories and template folders. Continue?');">Delete</a>
            </td>
          </tr>
        <?php endwhile; ?>
      <?php else: ?>
        <tr><td colspan="6" style="text-align:center; padding: 40px; color:#999;">No categories found.</td></tr>
      <?php endif; ?>
    </tbody>
  </table>
</div>

</body>
</html>