<?php 
session_start();
require_once 'config/auth_check.php';
require_once 'config/db.php';

// Fetching counts for the Dashboard Cards 
$stats = [
    'categories' => $conn->query("SELECT COUNT(*) as total FROM categories")->fetch_assoc()['total'],
    'sub_categories' => $conn->query("SELECT COUNT(*) as total FROM sub_categories")->fetch_assoc()['total'],
    'upliners' => $conn->query("SELECT COUNT(*) as total FROM upliners")->fetch_assoc()['total'],
    'templates' => $conn->query("SELECT COUNT(*) as total FROM templates")->fetch_assoc()['total'],
    'musics' => $conn->query("SELECT COUNT(*) as total FROM musics")->fetch_assoc()['total'],
    'stories' => $conn->query("SELECT COUNT(*) as total FROM stories WHERE status='Active'")->fetch_assoc()['total'],
    'banners' => $conn->query("SELECT COUNT(*) as total FROM banners WHERE status='Active'")->fetch_assoc()['total'],
    'companies' => $conn->query("SELECT COUNT(*) as total FROM company")->fetch_assoc()['total'],
    'users' => $conn->query("SELECT COUNT(*) as total FROM users")->fetch_assoc()['total'],
    'effects' => $conn->query("SELECT COUNT(*) as total FROM effects")->fetch_assoc()['total'] // Assuming table exists
];

// 2. MANUAL DATA: (To be automated later)
$manual_sales = "₹15,800"; 
$manual_server_load = 42; // Percentage
$server_color = ($manual_server_load > 80) ? '#e74c3c' : '#2ecc71';

// Fetch Registered Companies for the bottom table
$company_res = $conn->query("SELECT * FROM company ORDER BY created_at DESC LIMIT 10");
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Grovia | Admin Dashboard</title>
    <style>
        :root { --sidebar-bg: #3b4368; --accent: #3498db; --bg-body: #f4f7f6; }
        body { margin: 0; font-family: 'Segoe UI', sans-serif; background: var(--bg-body); display: flex; }
        .sidebar { width: 280px; background: var(--sidebar-bg); height: 100vh; position: fixed; color: #fff; }
        .main-content { margin-left: 280px; width: 100%; padding: 40px; }

        /* Stats Grid - Now 4 columns for balance */
        .stats-grid { display: grid; grid-template-columns: repeat(4, 1fr); gap: 20px; margin-bottom: 40px; }
        
        .stat-card { background: #fff; padding: 20px; border-radius: 12px; box-shadow: 0 4px 15px rgba(0,0,0,0.05); position: relative; overflow: hidden; }
        .stat-label { font-size: 11px; text-transform: uppercase; color: #95a5a6; font-weight: 700; letter-spacing: 0.5px; }
        .stat-value { display: block; font-size: 24px; font-weight: 700; color: #2c3e50; margin-top: 5px; }
        
        /* Server Load Bar */
        .load-bar-bg { background: #eee; height: 6px; border-radius: 3px; margin-top: 15px; width: 100%; }
        .load-bar-fill { background: <?php echo $server_color; ?>; height: 100%; border-radius: 3px; transition: 1s ease-in-out; }

        .table-card { background: #fff; padding: 25px; border-radius: 12px; box-shadow: 0 4px 20px rgba(0,0,0,0.05); }
        .modern-table { width: 100%; border-collapse: collapse; margin-top: 20px; }
        .modern-table th { text-align: left; padding: 12px; color: #95a5a6; font-size: 11px; text-transform: uppercase; border-bottom: 2px solid #f8f9fa; }
        .modern-table td { padding: 12px; border-bottom: 1px solid #f8f9fa; font-size: 13px; }
        
        .badge-success { background: #e8f5e9; color: #2e7d32; padding: 4px 10px; border-radius: 20px; font-size: 10px; font-weight: bold; }

        body { margin: 0; font-family: 'Segoe UI', sans-serif; background: var(--bg-body); display: flex; }

        /* Sidebar Styling */
        .sidebar { width: 280px; background: var(--sidebar-bg); height: 100vh; position: fixed; color: #fff; }
        .logo-area { padding: 30px; text-align: center; border-bottom: 1px solid rgba(255,255,255,0.1); }
        .menu-link { display: block; padding: 18px 25px; color: #fff; text-decoration: none; border-bottom: 1px solid rgba(255,255,255,0.1); transition: 0.3s; }
        .menu-link:hover, .active { background: rgba(255,255,255,0.1); border-left: 4px solid var(--accent); }

        /* Main Content */
        .main-content { margin-left: 280px; width: 100%; padding: 40px; }
        
        /* Stats Grid  */
        .stats-grid { display: grid; grid-template-columns: repeat(auto-fill, minmax(220px, 1fr)); gap: 20px; margin-bottom: 40px; }
        .stat-card { background: var(--white); padding: 25px; border-radius: 12px; box-shadow: 0 4px 15px rgba(0,0,0,0.05); display: flex; flex-direction: column; }
        .stat-label { font-size: 12px; text-transform: uppercase; color: #888; letter-spacing: 1px; margin-bottom: 10px; }
        .stat-value { font-size: 28px; font-weight: 700; color: #2c3e50; }
        .stat-icon { color: var(--accent); opacity: 0.2; position: absolute; right: 20px; bottom: 20px; font-size: 40px; }

        /* Modern Table Card */
        .table-card { background: #fff; padding: 30px; border-radius: 12px; box-shadow: 0 4px 20px rgba(0,0,0,0.05); }
        .modern-table { width: 100%; border-collapse: collapse; margin-top: 20px; }
        .modern-table th { text-align: left; padding: 15px; border-bottom: 2px solid #f4f7f6; color: #95a5a6; font-size: 11px; text-transform: uppercase; }
        .modern-table td { padding: 15px; border-bottom: 1px solid #f4f7f6; font-size: 14px; color: #333; }
        
        .logo-thumb { width: 40px; height: 40px; object-fit: contain; border: 1px solid #eee; border-radius: 6px; }
        .badge-code { background: #e1f5fe; color: #0288d1; padding: 4px 8px; border-radius: 4px; font-size: 11px; font-weight: bold; }
    </style>
</head>
<body>

<?php include ('side-bar.php')?>

<div class="main-content">
    <h2 style="margin-top:0;">Grovia Dashboard</h2>
    <p style="color:#888; margin-bottom:30px;">Real-time analytics across your digital assets.</p>

    <div class="stats-grid">
        <div class="stat-card">
            <span class="stat-label">Companies</span>
            <span class="stat-value"><?php echo $stats['companies']; ?></span>
        </div>
        <div class="stat-card">
            <span class="stat-label">Categories</span>
            <span class="stat-value"><?php echo $stats['categories']; ?></span>
        </div>
        <div class="stat-card">
            <span class="stat-label">Sub-Categories</span>
            <span class="stat-value"><?php echo $stats['sub_categories']; ?></span>
        </div>
        <div class="stat-card">
            <span class="stat-label">Active Stories</span>
            <span class="stat-value" style="color: #e67e22;"><?php echo $stats['stories']; ?></span>
        </div>
        <div class="stat-card">
            <span class="stat-label">Total Templates</span>
            <span class="stat-value"><?php echo $stats['templates']; ?></span>
        </div>
        <div class="stat-card">
            <span class="stat-label">Music Uploaded</span>
            <span class="stat-value"><?php echo $stats['musics']; ?></span>
        </div>
        <div class="stat-card">
            <span class="stat-label">Upliners</span>
            <span class="stat-value"><?php echo $stats['upliners']; ?></span>
        </div>
        <div class="stat-card">
            <span class="stat-label">Active Banners</span>
            <span class="stat-value" style="color: #2ecc71;"><?php echo $stats['banners']; ?></span>
        </div>

        <div class="stat-card">
            <span class="stat-label">Total Users</span>
            <span class="stat-value"><?php echo number_format($stats['users']); ?></span>
        </div>
        <div class="stat-card">
            <span class="stat-label">Total Effects</span>
            <span class="stat-value"><?php echo $stats['effects']; ?></span>
        </div>

        <div class="stat-card">
            <span class="stat-label">Total Sales</span>
            <span class="stat-value" style="color: #27ae60;"><?php echo $manual_sales; ?></span>
        </div>
        
        <div class="stat-card">
            <span class="stat-label">Server Load</span>
            <span class="stat-value"><?php echo $manual_server_load; ?>%</span>
            <div class="load-bar-bg">
                <div class="load-bar-fill" style="width: <?php echo $manual_server_load; ?>%"></div>
            </div>
        </div>
    </div>

    <div class="table-card">
        <div style="display: flex; justify-content: space-between; align-items: center;">
            <h3 style="margin:0;">Recently Registered Companies</h3>
            <a href="manage-companies.php" style="color: var(--accent); text-decoration: none; font-size: 13px; font-weight: 600;">View All Entities →</a>
        </div>
        
        <table class="modern-table">
            <thead>
                <tr>
                    <th>Identifier</th>
                    <th>Logo</th>
                    <th>Company Name</th>
                    <th>Registered On</th>
                    <th>Action</th>
                </tr>
            </thead>
            <tbody>
                <?php while($row = $company_res->fetch_assoc()): ?>
                <tr>
                    <td><span class="badge-code"><?php echo $row['company_code']; ?></span></td>
                    <td><img src="<?php echo $row['left_logo']; ?>" class="logo-thumb" onerror="this.src='assets/img/no-logo.png'"></td>
                    <td><strong><?php echo htmlspecialchars($row['company_name']); ?></strong></td>
                    <td><?php echo date('d M, Y', strtotime($row['created_at'])); ?></td>
                    <td><a href="edit-company.php?id=<?php echo $row['id']; ?>" style="color:var(--accent); text-decoration:none;">Manage</a></td>
                </tr>
                <?php endwhile; ?>
            </tbody>
        </table>
    </div>
</div>

</body>
</html>