<?php
require_once '../config/db.php'; // Ensure this path is correct based on your folder structure

header('Content-Type: application/json');

if (isset($_GET['company_id'])) {
    // Force the ID to be an integer for security
    $company_id = intval($_GET['company_id']);

    // Standard query (No question marks here!)
    $query = "SELECT u.id, u.upliner_name, u.upliner_code, u.photo_1 
              FROM upliners u
              INNER JOIN company_upliners cu ON u.id = cu.upliner_id
              WHERE cu.company_id = $company_id AND u.status = 'active'";

    $result = $conn->query($query);
    $upliners = [];

    if ($result) {
        while ($row = $result->fetch_assoc()) {
            // Fix the photo path if it's stored as a relative path
            $row['photo_1'] = !empty($row['photo_1']) ? $row['photo_1'] : 'assets/img/default-avatar.png';
            $upliners[] = $row;
        }
        echo json_encode($upliners);
    } else {
        // Send the error back as JSON so JavaScript can read it
        echo json_encode(["error" => $conn->error]);
    }
} else {
    echo json_encode([]);
}
exit();
?>