<?php 
session_start();
require_once 'config/auth_check.php';
require_once 'config/db.php';
?>
<!DOCTYPE html>
<html>
<head>
    <title>Admin - Add Effect</title>
    <link rel="stylesheet" href="assets/css/admin.css">
    <style>
        .effect-preview {
            width: 150px;
            height: 150px;
            border: 2px dashed #ccc;
            display: flex;
            align-items: center;
            justify-content: center;
            background: #f0f0f0;
            margin-bottom: 10px;
            overflow: hidden;
        }
        #previewImg { max-width: 100%; max-height: 100%; display: none; }


        .alert { padding: 15px; margin-bottom: 20px; border-radius: 4px; text-align: center; }
    .success { background-color: #d4edda; color: #155724; border: 1px solid #c3e6cb; }
    .error { background-color: #f8d7da; color: #721c24; border: 1px solid #f5c6cb; }
    </style>
</head>
<body>

<?php include 'side-bar.php' ?>

<div class="main">
    <h2>Add New Graphic Effect</h2>
    <div id="msg" class="alert"></div>

    <form id="addEffectForm" enctype="multipart/form-data">
        <label>Effect File (PNG/Overlay)</label>
        <div class="effect-preview">
            <img id="previewImg" src="">
            <span id="placeholder">Preview</span>
        </div>
        <input type="file" name="effect_file" id="effectInp" accept="image/gif" required>

        <label>Price (Set 0 for Free)</label>
        <input type="number" name="price" step="1" value="0" required>

        <label>Status</label>
        <select name="status">
            <option value="Active">Active</option>
            <option value="Not Active">Not Active</option>
        </select>

        <button type="submit" style="margin-top: 20px; background: #9b59b6; color: white;">Save Effect</button>
    </form>
</div>

<script>
    document.getElementById('effectInp').onchange = e => {
        const [file] = e.target.files;
        if (file) {
            document.getElementById('previewImg').src = URL.createObjectURL(file);
            document.getElementById('previewImg').style.display = 'block';
            document.getElementById('placeholder').style.display = 'none';
        }
    };

    document.getElementById('addEffectForm').onsubmit = async (e) => {
        e.preventDefault();
        const res = await fetch("api/save-effect.php", {
            method: "POST",
            body: new FormData(e.target)
        });
        const data = await res.json();
        const msg = document.getElementById('msg');
        msg.style.display = "block";
        msg.className = "alert " + (data.success ? "success" : "error");
        msg.innerText = data.message;
        if(data.success) {
            e.target.reset();
            document.getElementById('previewImg').style.display = 'none';
            document.getElementById('placeholder').style.display = 'block';
        }
    };
</script>
</body>
</html>