<?php 
require_once 'config/auth_check.php';
session_start(); ?>
<!DOCTYPE html>
<html>
<head>
  <title>Admin Panel - Add Company</title>
  <link rel="stylesheet" href="assets/css/admin.css">

<style>
    .alert { padding: 15px; margin-bottom: 20px; border-radius: 4px; text-align: center; }
    .success { background-color: #d4edda; color: #155724; border: 1px solid #c3e6cb; }
    .error { background-color: #f8d7da; color: #721c24; border: 1px solid #f5c6cb; }
    .logo-preview-container { display: flex; gap: 20px; margin-bottom: 15px; }
    .logo-box { flex: 1; border: 1px dashed #ccc; padding: 10px; text-align: center; }
    .logo-box img { max-width: 100%; height: 80px; display: none; margin-top: 10px; }
  </style>

  <style>
    /* Additional styles for logo previews */
    .logo-preview-container {
      display: flex;
      gap: 20px;
      margin-bottom: 15px;
      margin-top:15px;
    }
    .logo-box {
      flex: 1;
      border: 1px dashed #ccc;
      padding: 10px;
      text-align: center;
      border-radius: 5px;
    }
    .logo-box img {
      max-width: 100%;
      height: 80px;
      object-fit: contain;
      display: none; /* Hidden until file is selected */
      margin-top: 10px;
    }
    label { font-size: 14px; color: #555; display: block; margin-bottom: 5px; }
  </style>
</head>
<body>

<?php include 'side-bar.php' ?>

<div class="main">
  <h2>Register New Company</h2>

  <?php if (isset($_SESSION['msg'])): ?>
    <div class="alert <?php echo $_SESSION['msg_type']; ?>">
      <?php 
        echo $_SESSION['msg']; 
        unset($_SESSION['msg']); // Clear message so it doesn't show again on refresh
      ?>
    </div>
  <?php endif; ?>

  <form id="addCompanyForm" action="api/save-company.php" method="POST" enctype="multipart/form-data">
    
    <label>Company Details</label>
    <input name="company_name" placeholder="Company Name (e.g., ABC Pvt Ltd)" required>    
    <input name="company_code" placeholder="GVCXXXX (Auto-generated)" readonly style="background: #f0f0f0;">

    <div class="logo-preview-container">
      <div class="logo-box">
        <label>Left Logo</label>
        <input type="file" name="left_logo" id="leftLogoInput" accept="image/*" required>
        <img id="leftPreview" src="#" alt="Left Logo Preview">
      </div>

      <div class="logo-box">
        <label>Right Logo</label>
        <input type="file" name="right_logo" id="rightLogoInput" accept="image/*" required>
        <img id="rightPreview" src="#" alt="Right Logo Preview">
      </div>
    </div>

    <button type="submit">Register Company</button>
    <p id="msg"></p>
  </form>
</div>

<script>
  // Script to handle image previews
  function setupPreview(inputId, imgId) {
    document.getElementById(inputId).onchange = evt => {
      const [file] = document.getElementById(inputId).files;
      if (file) {
        const preview = document.getElementById(imgId);
        preview.src = URL.createObjectURL(file);
        preview.style.display = 'block';
      }
    }
  }

  setupPreview('leftLogoInput', 'leftPreview');
  setupPreview('rightLogoInput', 'rightPreview');
</script>

</body>
</html>